/*************************************************************************
 * DISCLAIMER                                                            *
 * Services performed by FREESCALE in this matter are performed          *
 * AS IS and without any warranty. CUSTOMER retains the final decision   *
 * relative to the total design and functionality of the end product.    *
 * FREESCALE neither guarantees nor will be held liable by CUSTOMER      *
 * for the success of this project. FREESCALE disclaims all warranties,  *
 * express, implied or statutory including, but not limited to,          *
 * implied warranty of merchantability or fitness for a particular       *
 * purpose on any hardware, software ore advise supplied to the project  *
 * by FREESCALE, and or any product resulting from FREESCALE services.   *
 * In no event shall FREESCALE be liable for incidental or consequential *
 * damages arising out of this agreement. CUSTOMER agrees to hold        *
 * FREESCALE harmless against any and all claims demands or actions      *
 * by anyone on account of any damage, or injury, whether commercial,    *
 * contractual, or tortuous, rising directly or indirectly as a result   *
 * of the advise or assistance supplied CUSTOMER in connection with      *
 * product, services or goods supplied under this Agreement.             *
 *************************************************************************/
 /**
  Copyright (c) 2007 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	GPIO.h
  \brief    	GPIO initialization functions
  \author   	Freescale Semiconductor
  \author     Samuel Quiroz
  \author   	Guadalajara Applications Laboratory RTAC Americas
  \version    1.0
  \date     	April 21, 2008

  * History:
  
  30/July/2007      Start of application coding                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
*/
#ifndef _GPIO
#define _GPIO

/* Includes */
#include "derivative.h"     /* include peripheral declarations */

/* Definitions */
#define SWITCH0     PTGD_PTGD0
#define SWITCH1     PTGD_PTGD1
#define SWITCH2     PTGD_PTGD2
#define SWITCH3     PTGD_PTGD3

#define SWITCH0_DD     PTGDD_PTGDD0
#define SWITCH1_DD     PTGDD_PTGDD1
#define SWITCH2_DD     PTGDD_PTGDD2
#define SWITCH3_DD     PTGDD_PTGDD3


#define SWITCH0_PE  PTGPE_PTGPE0
#define SWITCH1_PE  PTGPE_PTGPE1
#define SWITCH2_PE  PTGPE_PTGPE2
#define SWITCH3_PE  PTGPE_PTGPE3

#define LED0    PTDD_PTDD2
#define LED1    PTFD_PTFD5
#define LED2    PTCD_PTCD4
#define LED3    PTCD_PTCD2
#define LED4    PTFD_PTFD1
#define LED5    PTFD_PTFD0
#define LED6    PTED_PTED3
#define LED7    PTED_PTED2

#define LED0_DD    PTDDD_PTDDD2
#define LED1_DD    PTFDD_PTFDD5
#define LED2_DD    PTCDD_PTCDD4
#define LED3_DD    PTCDD_PTCDD2
#define LED4_DD    PTFDD_PTFDD1
#define LED5_DD    PTFDD_PTFDD0
#define LED6_DD    PTEDD_PTEDD3
#define LED7_DD    PTEDD_PTEDD2

#define SWITCHES_PORT    (~PTGD) & 0x0F

/* Prototypes */
void GPIO_Init(void);


#endif /* _GPIO_H */
